/*************************************************************
Advance IC card/Cpu Card/RF card header file for Windows 95&NT   
						Version 7
	(C)Copyrigths by ACI, All Rights Reserved. 1999.10       
	Access Control Innovation Limited 

*************************************************************/

/* Communication  Port */

#define COM1            0    /* COM1 Port */
#define COM2            1    /* COM1 Port */
#define COM3            2    /* COM1 Port */
#define COM4            3    /* COM1 Port */
#define COM5            4    /* COM1 Port */
#define COM6            5    /* COM1 Port */
#define COM7            6    /* COM1 Port */
#define COM8            7    /* COM1 Port */
#define COM9            8    /* COM1 Port */
#define COM10           9    /* COM1 Port */

/* Card Type */

#define SLE4404     00    /* SIEMENS SLE4404     Card */
#define SLE4432     01    /* SIEMENS SLE4432     Card */
#define SLE4442     02    /* SIEMENS SLE4442     Card */
#define SLE4418     03    /* SIEMENS SLE4418     Card */
#define SLE4428     04    /* SIEMENS SLE4428     Card */

#define AT24C01A    10    /* ATMEL 24C01A        Card */
#define AT24C02     11    /* ATMEL 24C02         Card */
#define AT24C04     12    /* ATMEL 24C04         Card */
#define AT24C08     13    /* ATMEL 24C08         Card */
#define AT24C16     14    /* ATMEL 24C16         Card */
#define AT88SC101   15    /* ATMEL 88SC101       Card */
#define AT88SC102   16    /* ATMEL 88SC102       Card */
#define AT88SC103   17    /* ATMEL 88SC103       Card */
#define AT24C32	    19
#define AT24C64	    20
#define AT45D041    21    /* AT45D041 */

#define AT93C46     22	  /* ATMEL 93C46         Card */
#define AT93C56     23	  /* ATMEL 93C56         Card */
#define AT93C66     24	  /* ATMEL 93C66         Card */
#define AT1604_A    25    /* ATMEL AT88SC1604       */
#define AT1604_N    26    /* ATMEL AT88SC1604         */
#define AT1608		27    /* ATMEL AT88SC1608    CARD */

#define CX24C01  	30	  /* X24C01              Card */

#define CpuCard		85	  /* Cpu Card Type */

/* Zone Table */

#define AZ         0x12    /* Application Zone */
#define PZ         0x11    /* Protect Zone */

 /* Net Command Structure of CPU Card */
struct CpuCardOsCommand{
	unsigned char CLA;
	unsigned char INS;
	unsigned char P1;
	unsigned char P2;
	unsigned char LC;
	unsigned char NetData[0x80];
	unsigned char LE;
};

/* Response Data Structure of CPU Card */
struct CpuCardResponse {
    unsigned char ResponseDataLength;
    unsigned char ResponseData[0x80];
};
/*TEMIC e5550 initialize */
struct RF5550Init
{
	long AOR ;
	long useBT ;
	long useST ;
	long usePWD ;
	long useSTOP ;
	long BR ;
	long MS1 ;
	long MS2 ;
	long PSKCF ;
	long MAXBLK ;
};

//TEMIC e5550 setup
#define AOR_yes     1 
#define AOR_no      0 

#define useBT_yes   1 
#define useBT_no    0 

#define useST_yes   1 
#define useST_no    0 

#define usePWD_yes  1 
#define usePWD_no   0 

#define useSTOP_yes 1 
#define useSTOP_no  0 

#define BR_RF8     0  //bitrate8cpb(Clock Per Bit)
#define BR_RF16    1  //bitrate16cpb(Clock Per Bit)
#define BR_RF32    2  //bitrate32cpb(Clock Per Bit)
#define BR_RF40	   3  //bitrate40cpb(Clock Per Bit)
#define BR_RF50    4  //bitrate50cpb(Clock Per Bit)
#define BR_RF64    5  //bitrate64cpb(Clock Per Bit)
#define BR_RF100   6  //bitrate100cpb(Clock Per Bit)
#define BR_RF128   7  //bitrate128cpb(Clock Per Bit)

#define MS1_direct            0 
#define MS1_Manchester		  1 
#define MS1_Biphase           2 
#define MS1_reserved          3 

#define MS2_direct  0  //direct
#define MS2_psk1	1  //phase change when input changes
#define MS2_psk2	2  //phase change on bitclk if input high
#define MS2_psk3	3  //phase change on rising edge of input
						//o/p freq        DATA=1          DATA=0
#define MS2_fsk1    4  //fsk1            rf/8            rf/5
#define MS2_fsk2	5 	//fsk2            rf/8            rf/10
#define MS2_fsk1a	6 	//fsk1a           rf/5            rf/8
#define MS2_fsk2a	7 	//fsk2a           rf/10           rf/8

#define PSKCF_RF2       0 
#define PSKCF_RF4       1 
#define PSKCF_RF8       2 
#define PSKCF_reserved  3 

#define MAXBLK_0		0 
#define MAXBLK_1		1 
#define MAXBLK_1to2		2 
#define MAXBLK_1to3		3 
#define MAXBLK_1to4		4 
#define MAXBLK_1to5		5 
#define MAXBLK_1to6		6 
#define MAXBLK_1to7		7 

/* IC Card Interface Functions */
long  pascal AutoLinkCom(long *Port);
long  pascal LinkCom(long port);
long  pascal UnLinkCom(void);
long  pascal PowerOn(void);
long  pascal PowerOff(void);
long  pascal ComBaudRate(void);
long  pascal SelectCard(long CardType);
long  pascal VerifyIC(void);
long  pascal Inquire(long *CardType, long *CardIn, long *Power);
long  pascal CheckSecret(long SecretLength, unsigned char *Secret);
long  pascal ReadSecret(unsigned char *SecretCounter, unsigned char *Secret);
long  pascal ModifySecret(long SecretLength, unsigned char *Secret);
long  pascal ReadCard(long Zone,long AddrH,long AddrL,long Len, unsigned char *Rece);
long  pascal WriteCard(long Zone,long AddrH,long AddrL,long Len, unsigned char *Send);
long  pascal EraseCard(long Zone,long AddrH,long AddrL,long Len, unsigned char *Send);
long  pascal CheckEraseSecret(long AppZoneNo, unsigned char *EraseSecret);
long  pascal CheckZoneSecret(long AppZoneNo, unsigned char *ZoneSecret); //new!
long  pascal SetZoneRWBit(long AppZoneNo, long RWBit); //new!
long  pascal SetStandby(void); //new!
long  pascal Fuse(long Level);
long  pascal GetDeviceNumber(unsigned char *DeviceNumber);
long  pascal EnDesData(unsigned char *UncryData , unsigned char *Password, unsigned char *EncryData, long DataLength);
long  pascal UnDesData(unsigned char *EncryData , unsigned char *Password, unsigned char *UncryData, long DataLength);
long  pascal ReadMemCard(long AddrBegin,long Len, unsigned char *Rece);
long  pascal WriteMemCard(long AddrBegin,long Len, unsigned char *Send);
long  pascal EraseMemCard(long AddrBegin,long Len, unsigned char *Send);
long  pascal WriteMemCardNoRead(long AddrBegin,long Len, unsigned char *Send);
long  pascal EraseMemCardNoRead(long AddrBegin,long Len, unsigned char *Send);
long  pascal CpuCardReset(unsigned char *CardResponseString);
long  pascal ProCpuCardCmd(struct CpuCardOsCommand *CardCommand, struct CpuCardResponse *CardResponse);
long  pascal ProCpuCard(unsigned char  *CardCommandString, unsigned char *CardResponseString);
long  pascal SamCard1Reset(unsigned char *CardResponseString);
long  pascal SamCard2Reset(unsigned char *CardResponseString);
long  pascal SamCard3Reset(unsigned char *CardResponseString);
long  pascal SamCard4Reset(unsigned char *CardResponseString);
long  pascal ProSamCard1Cmd(struct CpuCardOsCommand *CardCommand, struct CpuCardResponse *CardResponse);
long  pascal ProSamCard2Cmd(struct CpuCardOsCommand *CardCommand, struct CpuCardResponse *CardResponse);
long  pascal ProSamCard3Cmd(struct CpuCardOsCommand *CardCommand, struct CpuCardResponse *CardResponse);
long  pascal ProSamCard4Cmd(struct CpuCardOsCommand *CardCommand, struct CpuCardResponse *CardResponse);
long  pascal ProSamCard1(unsigned char  *CardCommandString, unsigned char *CardResponseString);
long  pascal ProSamCard2(unsigned char  *CardCommandString, unsigned char *CardResponseString);
long  pascal ProSamCard3(unsigned char  *CardCommandString, unsigned char *CardResponseString);
long  pascal ProSamCard4(unsigned char  *CardCommandString, unsigned char *CardResponseString);

/*      RF Card Read/Write Functions header file Version 0.1                 */
/*      (C)Copyright 1999.1.10 by CAST Enterprises,Ltd. All Rights Reserved. */
/*      Programmer : Atan                                                    */

/*For TEMIC e5550 RF CARD*/
//long  pascal RF5550_ReadBlk(long Blocknumber , unsigned char *ReceBuff);
//long  pascal RF5550_WriteBlk(long Blocknumber , unsigned char *PSW , unsigned char *SendBuff , long EnabledPSW);
//long  pascal RF5550_ModifyPSW(unsigned char *OldPSW , unsigned char *NewPSW , long EnabledPSW);
//long  pascal RF5550_Init(struct RF5550Init *InitStruct , unsigned char *PSW , long EnabledPSW) ;

long  pascal RF5550_ReadBlk(long Blocknumber , unsigned char *ReceBuff);
long  pascal RF5550_WriteBlk(long Blocknumber , unsigned char *PSW , unsigned char *SendBuff , long EnabledPSW);
long  pascal RF5550_Init(struct RF5550Init *InitStruct , unsigned char *PSW , long EnabledPSW);
long  pascal RF5550_Wake(unsigned char *PSW);
long  pascal RF5550_ReadAfterWake(long BlockNumber , unsigned char *PSW , unsigned char *ReceBuff);
long  pascal RF5550_WriteAfterWake(long BlockNumber , unsigned char *PSW , unsigned char *SendBuff , long EnabledPSW);
long  pascal RF5550_Mcmno(long * McmNo);

/*For Mifare M170 RF CARD*/
long  pascal RFMifare_Mcmno(long *McmNo);
long  pascal RFMifare_Authmode(long Authmode);
long  pascal RFMifare_TransKey(long Sector , unsigned char *WriteBuff);
long  pascal RFMifare_GetType(long *Type);
long  pascal RFMifare_GetSnr(long *Sn);
long  pascal RFMifare_ReadBlock(long BlockNo , long CardSn , unsigned char *ReadBuff);
long  pascal RFMifare_WriteBlock(long BlockNo , long CardSn , unsigned char *WriteBuff);
long  pascal RFMifare_WriteKey(long Sector , long CardSn , unsigned char *Key , unsigned char MLC);
long  pascal RFMifare_ReadValue(long BlockNo , long CardSn , long *Value);
long  pascal RFMifare_WriteValue(long BlockNo , long CardSn , long *Value);
long  pascal RFMifare_IncrementValue(long BlockNo , long CardSn , long *Value);
long  pascal RFMifare_DecrementValue(long BlockNo , long CardSn , long *Value);
long  pascal RFMifare_LoadKey(long Mode , long Sector , unsigned char *Key);
long  pascal RFMifare_Request(long Mode , long *CardTypeNo);
long  pascal RFMifare_AntiColl(long *CardSn);
long  pascal RFMifare_Select(long CardSn);
long  pascal RFMifare_Authentication(long Mode , long Sector , long BlockNo);
long  pascal RFMifare_Read(long BlockNo , unsigned char *ReadBuff);
long  pascal RFMifare_Write(long BlockNo , unsigned char *WriteBuff);
long  pascal RFMifare_Increment(long BlockNo , long Value);
long  pascal RFMifare_Decrment(long BlockNo , long Value);
long  pascal RFMifare_Halt(void);

/*For Atmel AT1608 CARD*/
long  pascal AT1608_Write(long ZoneNumber, long Offset ,long  WriteLength, unsigned char *SendBuff);
long  pascal AT1608_Read(long ZoneNumber, long Offset ,long  ReadLength, unsigned char *ReceBuff);
long  pascal AT1608_Psw(long PswIndex, unsigned char *Password);
long  pascal AT1608_Authentic(unsigned char *Q0 , unsigned char *Gc);
long  pascal AT1608_ReadFuse(unsigned char *Fuse);
long  pascal AT1608_Reset(void);

long  pascal AT1608_Psw_TF(long PswIndex, long VerNumber);
long  pascal AT1608_ModifyPsw_TF(long PswIndex, long VerNumber);
long  pascal AT1608_Authentic_TF(unsigned char *Q0, unsigned char i);

long  pascal DLLVER(void);
long  pascal CPUCardProtocolType(void);
long  pascal DEVVER(unsigned char *DEVVER);
long  pascal ALARM(long Device , long OneTime , long BetweenTime , long Times);

struct DateTime
{
	long  year;
	long  month;
	long  day;
	long  weekday;
	long  hour;
	long  min;
	long  sec;
};

long  pascal KQ_EndTrans();
long  pascal KQ_GetTime(struct DateTime *dt);
long  pascal KQ_SetTime(struct DateTime *dt);
long  pascal KQ_GetCurrentPos(long *page , long *addr);
long  pascal KQ_GetStartPos(struct DateTime *dt , long *page , long *addr);
long  pascal KQ_GetEndPos(struct DateTime *dt , long *page , long *addr);
long  pascal KQ_ReadRecord(long page , long addr , long len , unsigned char *recbuff);
long  pascal KQ_SysInit();
long  pascal KQ_Display(unsigned char *displaystr);
long  pascal KQ_TransCmd(long id , long len ,unsigned char *cmdbuff);
long  pascal KQ_Daysbyte(unsigned char *write_buff);
long  pascal KQ_Datebyte(long count , unsigned char *write_buff);
long  pascal KQ_DownloadPSW(long CardType , unsigned char *psw);